(function ($) {
    $.widget("dataprojekt.textEditor", {
        options: {
            textDocument: null,

            bold: "",
            italic: "",
            underline: "",
            superscript: "",
            subscript: "",
            listol: "",
            listul: "",
            color: ""
        },

        formatDoc: function (cmd, value) {
            document.execCommand(cmd, false, value);

            this.textDocument.focus();
        },

        saveSelection: function () {
            if (window.getSelection) {
                sel = window.getSelection();
                if (sel.getRangeAt && sel.rangeCount) {
                    return sel.getRangeAt(0);
                }
            } else if (document.selection && document.selection.createRange) {
                return document.selection.createRange();
            }
            return null;
        },

        restoreSelection: function (range) {
            if (range) {
                if (window.getSelection) {
                    sel = window.getSelection();
                    sel.removeAllRanges();
                    sel.addRange(range);
                } else if (document.selection && range.select) {
                    range.select();
                }
            }
        },

        _create: function () {
            var self = this;
            var text;

            this.toolbar = {
                container: $("<div></div>")
                    .addClass("dataprojektEditorToolbar"),

                group: $('<div></div>')
                    .addClass("btn-group ml-2 mr-2"),

                bold: $('<button type="button"><i class="fad fa-bold"></i></button>')
                    .addClass("btn btn-white btn-sm px-3")
                    .attr("data-toogle", "popover-hover")
                    .attr("data-content", self.bold)
                    .click(function () {
                        self.formatDoc('bold');
                    }),

                italic: $('<button type="button"><i class="fad fa-italic"></i></button>')
                    .addClass("btn btn-white btn-sm px-3")
                    .attr("data-toogle", "popover-hover")
                    .attr("data-content", self.italic)
                    .click(function () {
                        self.formatDoc('italic');
                    }),

                underline: $('<button type="button"><i class="fad fa-underline"></i></button>')
                    .addClass("btn btn-white btn-sm px-3")
                    .attr("data-toogle", "popover-hover")
                    .attr("data-content", self.underline)
                    .click(function () {
                        self.formatDoc('underline');
                    }),

                superscript: $('<button type="button"><i class="fad fa-superscript"></i></button>')
                    .addClass("btn btn-white btn-sm px-3")
                    .attr("data-toogle", "popover-hover")
                    .attr("data-content", self.superscript)
                    .click(function () {
                        self.formatDoc('superscript');
                    }),

                subscript: $('<button type="button"><i class="fad fa-subscript"></i></button>')
                    .addClass("btn btn-white btn-sm px-3")
                    .attr("data-toogle", "popover-hover")
                    .attr("data-content", self.subscript)
                    .click(function () {
                        self.formatDoc('subscript');
                    }),

                listol: $('<button type="button"><i class="fad fa-list-ol"></i></button>')
                    .addClass("btn btn-white btn-sm px-3")
                    .attr("data-toogle", "popover-hover")
                    .attr("data-content", self.listol)
                    .click(function () {
                        self.formatDoc('insertOrderedList');
                    }),

                listul: $('<button type="button"><i class="fad fa-list-ul"></i></button>')
                    .addClass("btn btn-white btn-sm px-3")
                    .attr("data-toogle", "popover-hover")
                    .attr("data-content", self.listul)
                    .click(function () {
                        self.formatDoc('insertUnorderedList');
                    }),

                colorButton: $('<button type="button"><i class="fad fa-palette"></i></button>')
                    .addClass("btn btn-white btn-sm px-3")
                    .attr("data-toogle", "popover-hover")
                    .attr("data-content", self.color)
                    .click(function () {
                        $(this).closest(".dataprojektEditorToolbar").find("input[type='color']").click();
                    }),

                colorInput: $('<input type="color" value="#000000">')
                    .addClass("d-none")
                    .click(function () {
                        this.text = self.saveSelection();
                    })
                    .change(function () {
                        self.restoreSelection(this.text);

                        self.formatDoc('foreColor', $(this).val());
                    })
            };

            var group_1 = this.toolbar.group.clone();
            group_1[0].appendChild(this.toolbar.bold[0]);
            group_1[0].appendChild(this.toolbar.italic[0]);
            group_1[0].appendChild(this.toolbar.underline[0]);

            var group_2 = this.toolbar.group.clone();
            group_2[0].appendChild(this.toolbar.superscript[0]);
            group_2[0].appendChild(this.toolbar.subscript[0]);

            var group_3 = this.toolbar.group.clone();
            group_3[0].appendChild(this.toolbar.listol[0]);
            group_3[0].appendChild(this.toolbar.listul[0]);

            var group_4 = this.toolbar.group.clone();
            group_4[0].appendChild(this.toolbar.colorButton[0]);
            group_4[0].appendChild(this.toolbar.colorInput[0]);

            this.toolbar.container[0].appendChild(group_1[0]);
            this.toolbar.container[0].appendChild(group_2[0]);
            this.toolbar.container[0].appendChild(group_3[0]);
            this.toolbar.container[0].appendChild(group_4[0]);

            this.toolbar.container.disableSelection();

            this.editor = $("<div></div>")
                .addClass("dataprojektEditor bg-white p-2 form-control overflow-auto")
                .attr("contentEditable", true);

            this.editor.html(this.element.text());

            this.container = $("<div></div>")
                .addClass("dataprojektEditorContainer")
                .height(50 + this.element.attr("rows") * 50 + "px")
                .insertBefore(this.element)
                .resizable({
                    handles: 's',
                    resize: function (e, ui) {
                        self._resize(e, ui);
                    }
                });

            this.container[0].appendChild(this.toolbar.container[0]);
            this.container[0].appendChild(this.editor[0]);
            this.container[0].appendChild(this.element[0]);

            this.textDocument = document.getElementsByClassName("dataprojektEditor")[0];
            this.element.hide();

            $('.dataprojektEditorToolbar [data-toogle="popover-hover"]').popover({
                html: true,
                trigger: 'hover',
                placement: 'top',
                delay: {
                    show: "500",
                    hide: "100"
                }
            });

            this._resize();
        },
        _resize: function (event) {
            var padding = this.editor.outerWidth() - this.editor.width() + 4,
                height = this.container.height() - this.toolbar.container.outerHeight() - padding - 8;

            this.editor
                .height(height);
        }
    });
})(jQuery);